uniform sampler2D tInput;
uniform sampler2D logodisplace;
uniform sampler2D edgemask;
uniform sampler2D logocolor;
uniform float testvalue;
uniform int demopart;
uniform float factor;
uniform float logofade;

const vec2 resolution=vec2(1920.0,1080.0);

float max_distort = 1.15/4.65/1.1f;

vec2 barrelDistortion(vec2 coord, float amt) {
float zoom=1.35/1.25/1.082;

    vec2 coord2=coord;

	vec2 cc = coord2 - vec2(0.5);
	float dist = dot(cc, cc);

	
	vec2 res=coord2 + cc * dist * amt;
	
	
	
	
	res=(res-vec2(0.5))/zoom+vec2(0.5);
	
	res = clamp(res,vec2(0.0+1.0/1920.0,0.0+1.0/1080),vec2(1.0-1.0/1920.0,1.0-1.0/1080));

	
	return res;
}

float sat( float t )
{
	return clamp( t, 0.0, 1.0 );
}

float linterp( float t ) {
	return sat( 1.0 - abs( 2.0*t - 1.0 ) );
}

float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

vec4 spectrum_offset( float t ) {
	vec4 ret;
	float lo = step(t,0.5);
	float hi = 1.0-lo;
	//float w = linterp( remap( t, 1.0/6.0, 5.0/6.0 ) );
	float w = linterp( remap( t, 0.1/6.0, 5.9/6.0 ) );
	
	ret = vec4(lo,1.0,hi, 1.) * vec4(1.0-w, w, 1.0-w, 1.);

	return pow( ret, vec4(1.0/2.2) );
}

const int num_iter = 6;
const float reci_num_iter_f = 1.0 / float(num_iter);

vec4 slidecolors (vec2 uv){
	//float displace = (testvalue);// /1920.0;
	vec4 color1 = texture2D( tInput, uv);
	vec4 color2 = texture2D( tInput, uv+vec2(3.0,0.0));
	color1.b = color2.b;
	return color1;
}

vec2 simpledisplace(vec2 uv, float displace){
	vec2 res = clamp(uv+vec2(displace,0.0),vec2(0.0+1.0/1920.0,0.0+1.0/1080),vec2(1.0-1.0/1920.0,1.0-1.0/1080));
	//vec2 res = clamp(uv+vec2(displace,0.0),vec2(0.1,0.1),vec2(0.9,0.9));
	return res;
}

void main()
{
/*
	vec2 uv=(gl_FragCoord.xy/resolution.xy);
	gl_FragColor = texture2D( tInput, uv);
*/

    //resolution.x=resolutionx; resolution.y=resolutiony;

	//vec2 uv=(gl_FragCoord.xy/resolution.xy*.5)+.25;
	//vec2 uv=(gl_FragCoord.xy/resolution.xy);//-.25/64.0;//.25/8.0
	///vec2 uv=(gl_FragCoord.xy/resolution.xy)+.25/12.5*2.0f;//.25/8.0
	vec2 uv=(gl_FragCoord.xy/resolution.xy);//.25/8.0
	vec2 uv2=uv;

	float factor_;//=testvalue;//factor;
	factor_=logofade*12.0;
	float logofactor_=clamp(logofade*1.5,0.0,1.0);

	if (factor_>0.0){
		vec3 disp = texture2D(logodisplace,uv).xyz-vec3(0.5,0.5,0.5);
		vec3 disp_;
		disp_.y=disp.g-disp.b;
		disp_.x=disp.r;
		//disp.y=(disp.y+disp.z)/2.0;
		vec2 displace=disp_.xy;//-vec2(0.5,0.5);
displace.x/=5.0;
displace.y*=1.5;
//displace.y+=0.25*0.125;
		float mask=texture2D(edgemask,uv).r;
		displace*=mask;
		uv+=(displace)*0.07*factor_;
		uv=clamp(uv,0,1);
	}
	
	vec4 sumcol = vec4(0.0);
	vec4 sumw = vec4(0.0);
	if (demopart==4){ // fisheye part
		for ( int i=0; i<num_iter; i++ )
		{
			float t = float(i) * reci_num_iter_f/2.0;
			vec4 w = spectrum_offset( t *2.0);
			sumw += w;
			float testvalue_=0.0056;//testvalue;
			vec4 col1 = w * texture2D(tInput, simpledisplace(barrelDistortion(uv, .6 * max_distort*t * (1.0-1.9)),testvalue_));
			vec4 col2 = w * texture2D(tInput, simpledisplace(barrelDistortion(uv+vec2(3.0/1920.0,0.0), .6 * max_distort*t * (1.0-1.9)),0.0));
			vec4 col3 = w * texture2D(tInput, simpledisplace(barrelDistortion(uv, .6 * max_distort*t * (1.0-1.9)),-testvalue_));
			vec4 col4 = col1; 
			col4.g=col2.g;
			col4.r=col3.r;
			col4.b*=1.2;
			sumcol += col4;
		}
	} else { // all other parts
		for ( int i=0; i<num_iter; i++ )
		{
			float t = float(i) * reci_num_iter_f/2.0;
			vec4 w = spectrum_offset( t *2.0);
			sumw += w;
			vec4 col1 = w * texture2D( tInput, barrelDistortion(uv, .6 * max_distort*t * (1.0-1.9)));
			vec4 col2 = w * texture2D( tInput, barrelDistortion(uv+vec2(3.0/1920.0,0.0), .6 * max_distort*t * (1.0-1.9)));
			vec4 col3 = col1; col3.b=col2.b;
			sumcol += col3;
		}
	}

	vec4 col=sumcol / sumw;

	//vec4 col2=slidecolors(uv);
/*
	int y=int(gl_FragCoord.y)%6;
	const float a=0.925;
	const float b=1.1;
	const float scanlines[6]={a,a,a-0.175,b,b,b+0.2};

	gl_FragColor = col*scanlines[y];
*/

	col=(col-vec4(0.5,0.5,0.5,0.0))*1.125+vec4(0.5,0.5,0.5,0.0); /// contrast adjustment
	
	vec4 col2=texture2D(logocolor,uv2);

	col=mix(col,col2,col2.a*logofactor_);
	gl_FragColor = col;

	//gl_FragColor = mix(col,col2,0.5);
	/*
	vec2 distort=barrelDistortion(uv, .6 * max_distort );
	vec4 w = spectrum_offset((distort.x+distort.y)/2.0f);
	gl_FragColor = w*texture2D( tInput, distort );
	*/
		
}
